/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.git.core.model.Diff;
import com.aptana.git.core.model.GitRef;
import com.aptana.git.core.model.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitCommit {
    private GitRepository repository;
    private String sha;
    private String subject;
    private long timestamp;
    private String author;
    private String authorEmail;
    private List<String> parentShas;
    private String comment;
    private List<Diff> diffs;

    public GitCommit(GitRepository repository, String sha) {
        this.repository = repository;
        this.sha = sha;
    }

    public List<String> parents() {
        return this.parentShas;
    }

    public Date date() {
        return new Date(this.timestamp);
    }

    public String sha() {
        return this.sha;
    }

    public GitRepository repository() {
        return this.repository;
    }

    void setSubject(String subject) {
        this.subject = subject;
    }

    void setAuthor(String author) {
        this.author = author;
    }

    void setTimestamp(long time) {
        this.timestamp = time;
    }

    void setParents(List<String> parents) {
        this.parentShas = new ArrayList<String>(parents);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("commit ").append(this.sha).append("\n");
        builder.append(this.getComment());
        return builder.toString();
    }

    void setComment(String comment) {
        this.comment = comment;
    }

    public synchronized List<Diff> getDiff() {
        if (this.diffs == null) {
            this.diffs = Diff.create(this);
        }
        return this.diffs;
    }

    private List<IResource> affectedResources() {
        IPath wd = this.repository.workingDirectory();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final IContainer container = root.getContainerForLocation(wd);
        if (container == null) {
            return Collections.emptyList();
        }
        return CollectionsUtil.map(this.affectedPaths(), (IMap)new IMap<IPath, IResource>(){

            public IResource map(IPath item) {
                return container.findMember(item);
            }
        });
    }

    public GitCommit getFirstParent() {
        if (CollectionsUtil.isEmpty(this.parents())) {
            return null;
        }
        return new GitCommit(this.repository, this.parentShas.get(0));
    }

    public boolean hasParent() {
        return !CollectionsUtil.isEmpty(this.parentShas);
    }

    public int parentCount() {
        if (CollectionsUtil.isEmpty(this.parentShas)) {
            return 0;
        }
        return this.parentShas.size();
    }

    public Collection<GitRef> getRefs() {
        if (this.repository.refs == null) {
            return Collections.emptyList();
        }
        return this.repository.refs.get(this.sha);
    }

    public boolean hasRefs() {
        return !CollectionsUtil.isEmpty(this.getRefs());
    }

    public int refCount() {
        if (!this.hasRefs()) {
            return 0;
        }
        return this.getRefs().size();
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GitCommit) {
            GitCommit other = (GitCommit)obj;
            return other.sha.equals(this.sha) && other.repository.equals(this.repository);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.sha.hashCode() + this.repository.hashCode();
    }

    private Collection<IPath> affectedPaths() {
        IPath wd = this.repository.workingDirectory();
        IStatus status = this.repository.execute(GitRepository.ReadWrite.READ, wd, (Map<String, String>)null, "diff-tree", "--name-only", "-r", this.sha);
        if (!status.isOK()) {
            return Collections.emptyList();
        }
        String output = status.getMessage();
        List<String> lines = Arrays.asList(StringUtil.LINE_SPLITTER.split(output));
        lines = lines.subList(1, lines.size());
        return CollectionsUtil.map(lines, (IMap)new IMap<String, IPath>(){

            public IPath map(String line) {
                return Path.fromPortableString((String)line);
            }
        });
    }

    public void refreshAffectedFiles() {
        Workspace w = (Workspace)ResourcesPlugin.getWorkspace();
        RefreshManager rm = w.getRefreshManager();
        List<IResource> affectedResources = this.affectedResources();
        for (IResource r : affectedResources) {
            rm.refresh(r);
        }
    }
}

